/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import com.google.common.collect.Lists;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.ValueModifyingPower;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.util.AttributeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public interface OriginComponent {
    public boolean hasOrigin(OriginLayer var1);

    public boolean hasAllOrigins();

    public HashMap<OriginLayer, Origin> getOrigins();

    public Origin getOrigin(OriginLayer var1);

    public boolean hadOriginBefore();

    public boolean hasPower(PowerType<?> var1);

    public <T extends Power> T getPower(PowerType<T> var1);

    public List<Power> getPowers();

    public <T extends Power> List<T> getPowers(Class<T> var1);

    public <T extends Power> List<T> getPowers(Class<T> var1, boolean var2);

    public void setOrigin(OriginLayer var1, Origin var2);

    public void serverTick();

    public void readFromNbt(CompoundNBT var1);

    public void writeToNbt(CompoundNBT var1);

    public void applySyncPacket(PacketBuffer var1);

    public void sync();

    public static void sync(PlayerEntity player) {
        ModComponentsArchitectury.syncOriginComponent((Entity)player);
    }

    public static <T extends Power> void withPower(Entity entity, Class<T> powerClass, Predicate<T> power, Consumer<T> with) {
        if (entity instanceof PlayerEntity) {
            Optional<Power> optional = ModComponentsArchitectury.getOriginComponent(entity).getPowers(powerClass).stream().filter(p -> power == null || power.test(p)).findAny();
            optional.ifPresent(with);
        }
    }

    public static <T extends Power> List<T> getPowers(Entity entity, Class<T> powerClass) {
        if (entity instanceof PlayerEntity) {
            return ModComponentsArchitectury.getOriginComponent(entity).getPowers(powerClass);
        }
        return Lists.newArrayList();
    }

    public static <T extends Power> boolean hasPower(Entity entity, Class<T> powerClass) {
        if (entity instanceof PlayerEntity) {
            return ModComponentsArchitectury.getOriginComponent(entity).getPowers().stream().anyMatch(p -> powerClass.isAssignableFrom(p.getClass()) && p.isActive());
        }
        return false;
    }

    public static <T extends ValueModifyingPower> float modify(Entity entity, Class<T> powerClass, float baseValue) {
        return (float)OriginComponent.modify(entity, powerClass, (double)baseValue, null, null);
    }

    public static <T extends ValueModifyingPower> float modify(Entity entity, Class<T> powerClass, float baseValue, Predicate<T> powerFilter) {
        return (float)OriginComponent.modify(entity, powerClass, (double)baseValue, powerFilter, null);
    }

    public static <T extends ValueModifyingPower> float modify(Entity entity, Class<T> powerClass, float baseValue, Predicate<T> powerFilter, Consumer<T> powerAction) {
        return (float)OriginComponent.modify(entity, powerClass, (double)baseValue, powerFilter, powerAction);
    }

    public static <T extends ValueModifyingPower> double modify(Entity entity, Class<T> powerClass, double baseValue) {
        return OriginComponent.modify(entity, powerClass, baseValue, null, null);
    }

    public static <T extends ValueModifyingPower> double modify(Entity entity, Class<T> powerClass, double baseValue, Predicate<T> powerFilter, Consumer<T> powerAction) {
        if (entity instanceof PlayerEntity) {
            List<T> powers = ModComponentsArchitectury.getOriginComponent(entity).getPowers(powerClass);
            List<AttributeModifier> mps = powers.stream().filter(p -> powerFilter == null || powerFilter.test(p)).flatMap(p -> p.getModifiers().stream()).collect(Collectors.toList());
            if (powerAction != null) {
                powers.stream().filter(p -> powerFilter == null || powerFilter.test(p)).forEach(powerAction);
            }
            return AttributeUtil.sortAndApplyModifiers(mps, baseValue);
        }
        return baseValue;
    }

    default public boolean checkAutoChoosingLayers(PlayerEntity player, boolean includeDefaults) {
        boolean choseOneAutomatically = false;
        ArrayList<OriginLayer> layers = new ArrayList<OriginLayer>();
        for (OriginLayer layer : OriginLayers.getLayers()) {
            if (!layer.isEnabled()) continue;
            layers.add(layer);
        }
        Collections.sort(layers);
        for (OriginLayer layer : layers) {
            boolean shouldContinue = false;
            if (layer.isEnabled() && !this.hasOrigin(layer)) {
                if (includeDefaults && layer.hasDefaultOrigin()) {
                    this.setOrigin(layer, OriginRegistry.get(layer.getDefaultOrigin()));
                    choseOneAutomatically = true;
                    shouldContinue = true;
                } else if (layer.getOriginOptionCount(player) == 1 && layer.shouldAutoChoose()) {
                    List origins = layer.getOrigins(player).stream().map(OriginRegistry::get).filter(Origin::isChoosable).collect(Collectors.toList());
                    if (origins.size() == 0) {
                        List<ResourceLocation> randomOrigins = layer.getRandomOrigins(player);
                        this.setOrigin(layer, OriginRegistry.get(randomOrigins.get(player.func_70681_au().nextInt(randomOrigins.size()))));
                    } else {
                        this.setOrigin(layer, (Origin)origins.get(0));
                    }
                    choseOneAutomatically = true;
                    shouldContinue = true;
                } else if (layer.getOriginOptionCount(player) == 0) {
                    shouldContinue = true;
                }
            } else {
                shouldContinue = true;
            }
            if (shouldContinue) continue;
            break;
        }
        return choseOneAutomatically;
    }
}

